<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

function umg_get_catcounters ($catids, $category)
{
	global $category_cache, $vbulletin;

	$counters = array ();
	if (is_array ($catids) AND !empty ($catids))
	{
		foreach ($catids AS $catid)
		{
			$counters['medias'] = $counters['medias'] + $category_cache["$catid"]['mediacount'];
			$counters['comments'] = $counters['comments'] + $category_cache["$catid"]['commentcount'];
			if ($category_cache["$catid"]['comment_date'] > $counters['commentdate'])
			{
				$counters['commentid']   = $category_cache["$catid"]['commentid'];
				$counters['commentdate'] = $category_cache["$catid"]['comment_date'];
				$counters['ctitle']      = $category_cache["$catid"]['ctitle'];
				$counters['cuserid']     = $category_cache["$catid"]['cuserid'];
				$counters['cusername']   = $category_cache["$catid"]['cusername'];
				$counters['commentmid']  = $category_cache["$catid"]['commentmid'];
				$counters['catviews']    = $category_cache["$catid"]['catviews'];
			}
			if ($category_cache["$catid"]['media_date'] > $counters['mediadate'])
			{
				$counters['mediaid']     = $category_cache["$catid"]['mediaid'];
				$counters['filename']    = $category_cache["$catid"]['filename'];
				$counters['medtitle']    = $category_cache["$catid"]['medtitle'];
				$counters['mediadate']   = $category_cache["$catid"]['media_date'];
			}
		}
	}
	else if ($catids AND !is_array ($catids))
	{
		$counters['medias']   = $counters['medias'] + $category_cache["$catids"]['mediacount'];
		$counters['comments'] = $counters['comments'] + $category_cache["$catids"]['commentcount'];
		if ($category_cache["$catids"]['comment_date'] > $counters['commentdate'])
		{
			$counters['commentid']   = $category_cache["$catids"]['commentid'];
			$counters['commentdate'] = $category_cache["$catids"]['comment_date'];
			$counters['ctitle']      = $category_cache["$catids"]['ctitle'];
			$counters['cuserid']     = $category_cache["$catids"]['cuserid'];
			$counters['cusername']   = $category_cache["$catids"]['cusername'];
			$counters['commentmid']  = $category_cache["$catids"]['commentmid'];
			$counters['catviews']    = $category_cache["$catids"]['catviews'];
		}
		if ($category_cache["$catids"]['media_date'] > $counters['mediadate'])
		{
			$counters['mediaid']     = $category_cache["$catids"]['mediaid'];
			$counters['filename']    = $category_cache["$catids"]['filename'];
			$counters['medtitle']    = $category_cache["$catids"]['medtitle'];
			$counters['mediadate']   = $category_cache["$catids"]['media_date'];
		}
	}

	if (!$counters['mediaid'] AND $category['mediaid'])
	{
		$counters['mediaid']  = $category['mediaid'];
		$counters['filename'] = $category['filename'];
		$counters['medtitle'] = $category['medtitle'];
	}

	if (!$counters['catviews'] AND $category['catviews'])     $counters['catviews'] += $category['catviews'];
	if (!$counters['medias']   AND $category['mediacount'])   $counters['medias'] = $category['mediacount'];
	if (!$counters['comments'] AND $category['commentcount'])	$counters['comments'] += $category['commentcount'];

	if ($category['comment_date'] > $counters['commentdate'])
	{
		$counters['commentid']   = $category['commentid'];
		$counters['commentdate'] = $category['comment_date'];
		$counters['ctitle']      = $category['ctitle'];
		$counters['cuserid']     = $category['cuserid'];
		$counters['cusername']   = $category['cusername'];
		$counters['commentmid']  = $category['commentmid'];
	}

	return $counters;
}

// this function will check the "fileheader" of X bytes given from $head
// it's currently not working
function umg_check_imgmed ($filename, $mime, $head)
{
	$extension = explode ('.', $filename);
	$extension = array_pop ($extension);
	$extension = strtolower ($extension);
	if (in_array ($extension, $mime))
	{
		foreach ($mime AS $key => $val)
		{
			if ($val == $extension) break;
		}
		$value = $head["$key"];

		$handle = @fopen ($filename, 'r');
		if ($handle)
		{
			$data = @fread ($handle, 50);
			@fclose ($handle);

			$compare = '';
			if (is_array ($value))
			{
				foreach ($value AS $key => $val)
				{
					$compare = '';
					for ($x = 0; $x < strlen ($val);$x++)
					{
						$compare .= $data["$x"];
					}

					if ($value == $compare)
					{
						return true;
					}
					else
					{
						return false;
					}
				}
			}
			else
			{
				for ($x = 0; $x < strlen ($value);$x++)
				{
					$compare .= $data["$x"];
				}

				if ($value == $compare)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}
		else
		{
			// file not found !
			return false;
		}
	}
	else
	{
		// can't check, so give back TRUE
		return true;
	}
}

function umg_check_image ($filename)
{
	$mime = array (
		'gif',
		'png',
		'jpg',
		'jpeg',
	);
	$head = array (
		'GIF89',
		'PNG',
		chr (255) . chr (216) . chr (255) . chr (224) . chr (00) . chr (16) . 'JFIF',
		chr (255) . chr (216) . chr (255) . chr (224) . chr (00) . chr (16) . 'JFIF'
	);

//	$check = umg_check_imgmed ($filename, $mime, $head);

//	return $check;
	return true;
}

function umg_check_media ($filename)
{
	$mime = array (
		'swf',
		'kar',
		'mid',
		'midi',
		'avi',
		'divx',
		'ogg',
		'wma',
		'wmv',
		'ape',
		'asf',
		'asx',
		'flv',
		'mov',
		'mp3',
		'mp4',
		'mpeg',
		'wav',
		'wm'
	);
	$head = array (
		array ('FWS', 'CWS'),
		'MThd',
		'MThd',
		'RIFF',
		'RIFF',
		'Ogg',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'',
		'RIFF',
		''
	);

//	$check = umg_check_imgmed ($filename, $mime, $head);

//	return $check;
	return true;
}

function umg_store_customfield ($have_custom, $mediaid)
{
	global $db, $vbulletin, $custom_fields;

	if ($have_custom)
	{
		foreach ($custom_fields as $key => $val)
		{
			if ($val['active'])
			{
				$fieldid = 0;
				if ($val['fieldtype'] == 1 OR $val['fieldtype'] == 2)
				{
					// text | textarea | select
					$vbulletin->input->clean_array_gpc ('p', array (
						'field_' . $val['id'] => TYPE_NOHTML,
					));
				}
				else if ($val['fieldtype'] == 3 OR $val['fieldtype'] == 5)
				{
					// radio
					$vbulletin->input->clean_array_gpc ('p', array (
						'field_' . $val['id'] => TYPE_INT,
					));
				}
				else
				{
					// checkbox | multi-select
					$vbulletin->input->clean_array_gpc ('p', array (
						'field_' . $val['id'] => TYPE_ARRAY_INT,
					));
				}

				$fieldid = $val['id'];
				$f = 'field_' . $val['id'];
				if (is_array ($vbulletin->GPC["$f"]))
				{
					$insert = '';
					$vals = array ();
					foreach ($vbulletin->GPC["$f"] AS $custom => $value)
					{
						if ($val['fieldtype'] == 6) $vals[] = $value;
						else $vals[] = $custom;
					}
					if (!empty ($vals))
					{
						$insert = implode ('|||', $vals);
					}
				}
				else
				{
					$insert = '';
					if ($vbulletin->GPC["$f"] != '')
					{
						$insert = $vbulletin->GPC["$f"];
						if ($val['fieldtype'] == 1 OR $val['fieldtype'] == 2 OR $val['fieldtype'] == 5 OR $val['fieldtype'] == 6) $insert = $db->escape_string (addslashes ($vbulletin->GPC["$f"]));
					}
				}

				if ($fieldid)
				{
					if ($insert == '')
					{
						// delete the field from media
						$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_customfield WHERE mediaid=" . $mediaid . " AND customid=" . $fieldid);
						$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_customfield");
					}
					else
					{
						$media_field = $db->query_first ("SELECT customid FROM " . TABLE_PREFIX . "umg_customfield WHERE mediaid=" . $mediaid . " AND customid=" . $fieldid);
						if ($media_field['customid'])
						{
							// we need to upgrade the media field
							$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_customfield SET 
								value    ='" . $insert . "',
								fieldtype=" . $val['fieldtype'] . "
								WHERE mediaid=" . $mediaid . " 
								AND customid=" . $fieldid
							);
						}
						else
						{
							// new insert
							$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_customfield
								(`mediaid`,`customid`,`value`,`fieldtype`) 
								VALUES 
								(" . $mediaid . "," . $fieldid . ",'" . $insert . "'," . $val['fieldtype'] . ")
							");
						}
					}
				}
			}
		}
	}

}

function umg_generate_random ($limit)
{
	global $db, $vbphrase, $vbulletin, $stylevar, $search_timeshift;

	if ($limit)
	{
		$x = 0;
		$medias = $db->query_read ("SELECT 
			media.*,COUNT(comment.comid) AS comcount,user.username,comment.title AS ctitle,comment.comment,comment.userid AS cuserid,
			ca.permission,ca.userid AS gallery,comment.dateline AS cdateline,comment.comid 
			FROM " . TABLE_PREFIX . "umg_media AS media 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS ca ON (ca.catid=media.catid)
			LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.mediaid=media.mediaid " . $comment_query . ") 
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=media.userid) 
			WHERE media.active=0 
			" . $search_timeshift . "
			GROUP BY media.mediaid 
			ORDER BY RAND()
			LIMIT " . ($limit * 3)
		);
		$width = (100 / $limit) . '%';
		while ($media = $db->fetch_array ($medias))
		{
			if (in_array ($vbulletin->userinfo['usergroupid'], explode (',', $media['permission'])) AND $x < $limit OR UMGADMIN)
			{
				$x++;
				$size = 's';
				$show['info'] = false;

				$size = @getimagesize (DIR . '/umg_gallery/images/' . $media['gallery'] . '/small/' . $media['mediaid'] . '_' . $media['filename']);
				if (!$size[0]) $size[0] = 1;
				if (!$size[1]) $size[1] = 1;
				$ratio_w = 60 / $size[0];
				$ratio_h = 60 / $size[1];
				$ratio_m = min ($ratio_w, $ratio_h);
				$used_width  = $size[0];
				$used_height = $size[1];
				if ($ratio_m < 1)
				{
					$used_width  = round ($size[0]  * $ratio_m, 0);
					$used_height = round ($size[1] * $ratio_m, 0);
				}
				$thumbnail = '<img src="umg_view.php?' . $session['sessionurl'] . 'do=s&amp;mediaid=' . $media['mediaid'] . '" width="' . $used_width . 'px" height="' . $used_height . 'px" alt="' . $media['title'] . '" title="' . $media['title'] . '" border="0" />';

				eval ('$mediabit .= "' . fetch_template ('umg_mediabit') . '";');

				if ($x == $limit) break;
			}
		}
		if ($x >= 2) $colspan = 'colspan="' . $x . '"';

		eval ('$gallery_random = "' . fetch_template ('umg_random_pics') . '";');
	}

	return $gallery_random;
}

function umg_generate_newest ($limit)
{
	global $db, $vbphrase, $vbulletin, $stylevar, $search_timeshift;

	if ($limit AND $vbulletin->options['umg_newest_thumbs_row'])
	{
		$y = $x = 0;
		$max = $limit * $vbulletin->options['umg_newest_thumbs_row'];

		$medias = $db->query_read ("SELECT 
			media.*,COUNT(comment.comid) AS comcount,user.username,comment.title AS ctitle,comment.comment,comment.userid AS cuserid,
			ca.title AS ctitle,ca.permission,ca.userid AS gallery,comment.dateline AS cdateline,comment.comid 
			FROM " . TABLE_PREFIX . "umg_media AS media 
			LEFT JOIN " . TABLE_PREFIX . "umg_category AS ca ON (ca.catid=media.catid) 
			LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.mediaid=media.mediaid " . $comment_query . ") 
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=media.userid) 
			WHERE media.active=0 
			" . $search_timeshift . "
			GROUP BY media.mediaid 
			ORDER BY media.dateline DESC 
			LIMIT " . (($limit * $vbulletin->options['umg_newest_thumbs_row']) * 2)
		);
		while ($media = $db->fetch_array ($medias))
		{
			if (in_array ($vbulletin->userinfo['usergroupid'], explode (',', $media['permission'])) OR UMGADMIN)
			{
				if (!$x) $mediabit .= '<tr valign="bottom">';

				$x++;
				$size = 'm';
				$show['info'] = true;

				$media_size = umg_set_filesize ($media['filesize']);
				$media_rating = '&nbsp;';
				if ($media['votenum'])
				{
					$media['voteavg'] = vb_number_format ($media['votetotal'] / $media['votenum'], 2);
					$rating = round ($media['votetotal'] / $media['votenum']);

					$media_rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rating.gif\" alt=\"" . construct_phrase ($vbphrase['umg_rating_x_votes_y_average'], $media['votenum'], $media['voteavg']) . "\" border=\"0\" />";
				}

				$size = @getimagesize (DIR . '/umg_gallery/images/' . $media['gallery'] . '/small/' . $media['mediaid'] . '_' . $media['filename']);
				if (!$size[0]) $size[0] = 1;
				if (!$size[1]) $size[1] = 1;
				$ratio_w = 150 / $size[0];
				$ratio_h = 150 / $size[1];
				$ratio_m = min ($ratio_w, $ratio_h);
				$used_width  = $size[0];
				$used_height = $size[1];
				if ($ratio_m < 1)
				{
					$used_width  = round ($size[0]  * $ratio_m, 0);
					$used_height = round ($size[1] * $ratio_m, 0);
				}
				$thumbnail = '<img src="umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '" width="' . $used_width . 'px" height="' . $used_height . 'px" alt="' . $media['title'] . '" title="' . $media['title'] . '" border="0" />';

				eval ('$mediabit .= "' . fetch_template ('umg_mediabit') . '";');

				if ($x == $limit)
				{
					$y++;
					$x = 0;
					$mediabit .= '</tr>';
				}
				if ($y == $vbulletin->options['umg_newest_thumbs_row']) break;
			}
		}
		if ($x < $limit)
		{
			for ($a = $x; $a < $limit; $a++)
			{
				$mediabit .= '<td class="alt1" style="width:' . $width . '">&nbsp;</td>';
			}
			$mediabit .= '</tr>';
		}

		if ($x >= 2) $colspan = 'colspan="' . $x . '"';

		eval ('$gallery_newest = "' . fetch_template ('umg_newest_pics') . '";');
	}

	return $gallery_newest;
}

function umg_get_rgb ()
{
	global $stylevar;

	$r = 255;
	$g = 255;
	$b = 255;

	if ($stylevar['panel_bgcolor'])
	{
		$rgb = str_replace (array ('#', ';'), '', $stylevar['panel_bgcolor']);

		if (vbstrlen ($rgb) == 6)
		{
			$r = intval (@hexdec (substr ($rgb, 0, 2)));
			$g = intval (@hexdec (substr ($rgb, 2, 2)));
			$b = intval (@hexdec (substr ($rgb, 4, 2)));
		}
		else if (vbstrlen ($rgb) == 3)
		{
			$r = intval (@hexdec (str_repeat (substr ($rgb, 0, 1), 2)));
			$g = intval (@hexdec (str_repeat (substr ($rgb, 1, 1), 2)));
			$b = intval (@hexdec (str_repeat (substr ($rgb, 2, 1), 2)));
		}
	}

	return array ($r, $g, $b);
}

$umglite = 1;

function umg_latest_comment ($mediaid, $catid)
{
	global $db;

	$add_query = 'AND c.mediaid=' . $mediaid;
	if (is_array ($mediaid))
	{
		$newmids = '0,' . implode (',', $mediaid);
		$add_query = 'AND c.mediaid IN (' . $newmids . ')';
	}

	$com = $db->query_first ("SELECT 
		c.*,u.username 
		FROM " . TABLE_PREFIX . "umg_comment AS c 
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=c.userid) 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS m ON (m.mediaid=c.mediaid) 
		WHERE c.moderate=0 
		AND m.active=0 
		AND c.userid>0 
		" . $add_query . " 
		ORDER BY c.dateline DESC
	");
	if ($com['dateline'])
	{
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_counts SET commentmid=" . $com['mediaid'] . ",comment_username='" . $db->escape_string (addslashes ($com['username'])) . "',commentid=" . $com['comid'] . ",comment_date=" . $com['dateline'] . " WHERE catid=" . $catid);
	}
	else
	{
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_counts SET commentmid=0,comment_username='',commentid=0,comment_date=0 WHERE catid=" . $catid);
	}
	umg_create_datastore ('stats');
}

function umg_cache_load_config ($identifier, $safe_variables, $gb_options)
{
	$gb_options = umg_process_options ($gb_options);

	if (file_exists ((DIR . "/umg_gallery/media_sites/$identifier.php")))
	{
		require (DIR . "/umg_gallery/media_sites/$identifier.php");

		return compact ($safe_variables);
	}
	else
	{
		return false;
	}
}

function umg_process_options ($gb_options)
{
	global $vbulletin;

	if ($gb_options)
	{
		return $gb_options;
	}
	else
	{
		$gb_options = array (
			'title'		 => $vbulletin->options['gb_title'], 
			'width'		 => $vbulletin->options['gb_width'], 
			'height'	 => $vbulletin->options['gb_height'], 
			'autoplay' => $vbulletin->options['gb_autoplay'], 
			'loop'		 => $vbulletin->options['gb_loop']
		);

		return $gb_options;
	}
}

function umg_check_mimetype ()
{
	global $extension, $filename, $efilenamea, $imagedir;

	if ($extension == 'gif')
	{
		if (imagetypes () & IMG_GIF) $image = @imagecreatefromgif ($imagedir . $filename);
	}
	if ($extension == 'jpg' OR $extension == 'jpeg')
	{
		if (imagetypes () & IMG_JPG) $image = @imagecreatefromjpeg ($imagedir . $filename);
	}
	if ($extension == 'png')
	{
		if (imagetypes () & IMG_PNG) $image = @imagecreatefrompng ($imagedir . $filename);
	}

	$rename = '';
	if (!$image)
	{
		// this image isn't correct
		if (imagetypes () & IMG_GIF) $image = @imagecreatefromgif ($imagedir . $filename);
		if (!$image)
		{
			if (imagetypes () & IMG_JPG) $image = @imagecreatefromjpeg ($imagedir . $filename);
			if (!$image)
			{
				if (imagetypes () & IMG_PNG) $image = @imagecreatefrompng ($imagedir . $filename);
				if (!$image)
				{
					// unknown filetype - can't rename
				}
				else
				{
					// file needs to be rename into PNG
					$rename = 'png';
				}
			}
			else
			{
				// file needs to be rename into JPG
				$rename = 'jpg';
			}
		}
		else
		{
			// file needs to be rename into GIF
			$rename = 'gif';
		}
	}

	if ($rename)
	{
		@chmod ($imagedir . $filename, 0777);
		$new_filename = str_replace ('.' . $extension, '.' . $rename, strtolower ($filename));
		@rename ($imagedir . $filename, $imagedir . $new_filename);
		$extension = $rename;
		$filename = $new_filename;
		$efilename = $new_filename;
	}

	return array ('extension' => $extension, 'filename' => $filename, 'efilename' => $efilename);
}

function umg_store_media ($gallery, $catid, $hasexif, $title, $description, $filename, $extension, $filesize, $width, $height, $moderate, $efilename, $tags, $isconverter = 0, $userid = 0, $date = 0, $check_mime = 1)
{
	global $db, $vbulletin, $imagedir, $thumb_small_width, $thumb_small_height, $thumb_medium_width, $thumb_medium_height, $gallery_media_types;

	if (!$hasexif OR $hasexif == '') $hasexif = 0;
	if (!$filesize OR $filesize == '') $filesize = 0;

	$dat = TIMENOW;
	$uid = $vbulletin->userinfo['userid'];
	if ($isconverter AND $userid)
	{
		$uid = $userid;
		if ($date) $dat = $date;
	}

	// do an image check ! This will checks the image for it's mime_type
	// if you rename an PNG in JPG it will change the image to a correct JPG
	if ($check_mime AND ($extension == 'gif' OR $extension == 'png' OR $extension == 'jpg' OR $extension == 'jpeg'))
	{
		$fn = $imagedir . $filename;
		if (file_exists ($fn))
		{
			$image_vars = umg_check_mimetype ($fn);
			$filename = $image_vars['filename'];
			$efilename = $image_vars['efilename'];
			$extension = $image_vars['extension'];
		}
	}

	$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_media
		(
		 `category`,
		 `userid`,
		 `catid`,
		 `exif`,
		 `title`,
		 `description`,
		 `efilename`,
		 `filename`,
		 `filetype`,
		 `filesize`,
		 `width`,
		 `height`,
		 `dateline`,
		 `active`
		) 
		VALUES 
		(
		 " . $gallery . ",
		 " . $uid . ",
		 " . $catid . ",
		 " . $hasexif . ",
		 '" . $db->escape_string (addslashes ($title)) . "',
		 '" . $db->escape_string (addslashes ($description)) . "',
		 '" . $db->escape_string (addslashes ($efilename)) . "',
		 '" . $db->escape_string (addslashes ($filename)) . "',
		 '" . $db->escape_string (addslashes ($extension)) . "',
		 " . $filesize . ",
		 " . $width . ",
		 " . $height . ",
		 " . $dat . ",
		 " . $moderate . "
		)
	");
	$mediaid = $db->insert_id ();

	if ($tags != '')
	{
		$tag_array = explode (',', $tags);
		foreach ($tag_array AS $key => $val)
		{
			if (trim ($val) != '')
			{
				$dbtag = $db->query_first ("SELECT tagid FROM " . TABLE_PREFIX . "umg_tag WHERE tagtext='" . $db->escape_string (trim ($val)) . "'");
				$tagid = $dbtag['tagid'];
				if (!$tagid)
				{
					// store our tag into database
					$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_tag 
						(`tagtext`,`dateline`) 
						VALUES 
						('" . $db->escape_string (trim ($val)) . "'," . $dat . ")
					");
					$tagid = $db->insert_id ();
				}
				// check for double tags
				$dt = $db->query_first ("SELECT 
					tm.tagid,t.tagtext 
					FROM " . TABLE_PREFIX . "umg_tagmedia AS tm 
					LEFT JOIN " . TABLE_PREFIX . "umg_tag AS t ON (t.tagid=tm.tagid) 
					WHERE tm.mediaid=" . $vbulletin->GPC['m'] . "
					AND t.tagtext='" . $db->escape_string (trim ($val)) . "'
				");
				if (!$dt['tagid'])
				{
					// store the tagid for our medium
					$db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_tagmedia
						(`tagid`,`mediaid`,`userid`,`dateline`) 
						VALUES 
						(" . $tagid . "," . $mediaid . "," . $uid . "," . $dat . ")
					");
				}
			}
		}
	}

	$newname = $imagedir . $mediaid . '_' . $filename;
	@rename ($imagedir . $filename, $newname);
	if (!$isconverter)
	{
		umg_create_thumbnails ($extension, $mediaid . '_' . $filename, $gallery, 'small', array ('width' => $thumb_small_width, 'height' => $thumb_small_height), 75, $mediaid);
		umg_create_thumbnails ($extension, $mediaid . '_' . $filename, $gallery, 'medium', array ('width' => $thumb_medium_width, 'height' => $thumb_medium_height), 75, $mediaid);
	}

	return $mediaid;
}

// imagetype  = STRING (gif, jpg, png)
// filename   = STRING (filename like: 123_myimage.gif)
// userid     = INT    (galleryid)
// sub_folder = STRING (small, medium)
// size       = ARRAY  (width, height)
function umg_create_thumbnails ($imagetype, $filename, $userid, $sub_folder, $size, $quality = 75, $mediaid)
{
	global $db, $thumb_small_width, $thumb_small_height, $thumb_medium_width, $thumb_medium_height, $gallery_media_types;

	$old_img = '';
	$directory = DIR . '/umg_gallery/images/' . $userid;

	if ($imagetype != 'jpg' AND $imagetype != 'jpeg' AND $imagetype != 'gif' AND $imagetype != 'png')
	{
		// create a custom image
		$img_arr = $gallery_media_types;
		if (in_array ($imagetype, $img_arr))
		{
			foreach ($img_arr AS $key => $val)
			{
				if ($imagetype == $val)
				{
					$image = 'mediatype_' . $val . '.gif';
					break;
				}
			}
		}
		else if ($imagetype == 'url')
		{
			$image = 'mediatype_url.gif';
		}
		else $image = 'mediatype_blank.gif';

		$filename = $mediaid . '_' . $image;
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_media SET filename='" . $db->escape_string (addslashes ($image)) . "' WHERE mediaid=" . $mediaid);
		@copy (DIR . '/umg_gallery/images/' . $image, $directory . '/original/' . $filename);
		@chmod ($directory . '/original/' . $filename, 0777);
		$imagetype = 'gif';

//		return false;
	}

	// store the w/h for thumbnail
	if (count ($size) >= 2)
	{
		$new_width  = intval ($size['width']);
		$new_height = intval ($size['height']);
	}
	else
	{
		if ($sub_folder == 'small')
		{
			$new_width  = $thumb_small_width;
			$new_height = $thumb_small_height;
		}
		else if ($sub_folder == 'medium')
		{
			$new_width  = $thumb_medium_width;
			$new_height = $thumb_medium_height;
		}
		else
		{
			return false;
		}
	}

	if ($imagetype == 'gif')
	{
		if (imagetypes () & IMG_GIF) $oldimage = @imagecreatefromgif ($directory . '/original/' . $filename);
	}

	if ($imagetype == 'jpg' OR $imagetype == 'jpeg')
	{
		if (imagetypes () & IMG_JPG) $oldimage = @imagecreatefromjpeg ($directory . '/original/' . $filename);
	}

	if ($imagetype == 'png')
	{
		if (imagetypes () & IMG_PNG) $oldimage = @imagecreatefrompng ($directory . '/original/' . $filename);
	}

	if (!$oldimage)
	{
		return false;
	}
	else
	{
		$imagesize = @getimagesize ($directory . '/original/' . $filename);
		$original_width  = $imagesize[0];
		$original_height = $imagesize[1];
		$new_width       = $new_width;
		$new_height      = $new_height;

		// prepare the ratio for our image
		$ratio_w = $new_width  / $original_width;
		$ratio_h = $new_height / $original_height;
		$ratio_m = min ($ratio_w, $ratio_h);

		$used_width  = $original_width;
		$used_height = $original_height;
		if ($ratio_m < 1)
		{
			$used_width  = round ($original_width  * $ratio_m, 0);
			$used_height = round ($original_height * $ratio_m, 0);
		}

		if ($imagetype == 'jpg' OR $imagetype == 'jpeg' OR $imagetype == 'png')
		{
			// create thumbnail from JPG or PNG
			$newimage = @imagecreatetruecolor ($used_width, $used_height);

			if ($imagetype == 'png')
			{
				@imagealphablending ($newimage, false);
				@imagesavealpha ($newimage, true);
				$color = @imagecolorallocate ($newimage, 0, 0, 0);
				@imagecolortransparent ($newimage, $color);
			}
		}
		else
		{
			// create thumbnail from GIF
			$newimage = @imagecreate ($used_width, $used_height);
			$color   = @imagecolorallocate ($newimage, 0, 0, 0);
			@imagecolortransparent ($newimage, $color);
		}

		if (!$newimage) return false;

		$output = @imagecopyresampled ($newimage, $oldimage, 0, 0, 0, 0, $used_width, $used_height, $original_width, $original_height);

		if (!$output) return false;

		$output = false;
		$imagename = DIR . '/umg_gallery/images/' . $userid . '/' . $sub_folder . '/' . $filename;

		if ($imagetype == 'gif')
		{
			$output = @imagegif ($newimage, $imagename);
			@chmod ($imagename, 0777);
		}
		else if ($imagetype == 'jpg' OR $imagetype == 'jpeg')
		{
			if ($quality < 0 OR $quality > 100) $quality = 75;
			$output = @imagejpeg ($newimage, $imagename, $quality);
			@chmod ($imagename, 0777);
		}
		else if ($imagetype == 'png')
		{
			$output = @imagepng ($newimage, $imagename);
			@chmod ($imagename, 0777);
		}

		@imagedestroy ($oldimage);
		@imagedestroy ($newimage);

		return $output;
	}
}

function umg_get_users_filetypes ()
{
	global $vbulletin;

	$ugid = $vbulletin->userinfo['usergroupid'];
	$image_filetypes_public  = $vbulletin->usergroupcache["$ugid"]['imagetypes_public'];
	$image_filetypes_public  = umg_string_trimtoarray ($image_filetypes_public, ',');
	$media_filetypes_public  = $vbulletin->usergroupcache["$ugid"]['mediatypes_public'];
	$media_filetypes_public  = umg_string_trimtoarray ($media_filetypes_public, ',');
	$image_filetypes_private = $vbulletin->usergroupcache["$ugid"]['imagetypes_private'];
	$image_filetypes_private = umg_string_trimtoarray ($image_filetypes_private, ',');
	$media_filetypes_private = $vbulletin->usergroupcache["$ugid"]['mediatypes_private'];
	$media_filetypes_private = umg_string_trimtoarray ($media_filetypes_private, ',');

	return array (
		'it_public'  => $image_filetypes_public,
		'mt_public'  => $media_filetypes_public,
		'it_private' => $image_filetypes_private,
		'mt_private' => $media_filetypes_private,
	);
}

function umg_string_trimtoarray ($string, $char_to_explode)
{
	$new_array = array ();
	$old_array = explode ($char_to_explode, $string);
	if (count ($old_array))
	{
		foreach ($old_array AS $key => $val)
		{
			if ($val) $new_array[] = trim ($val);
		}
	}

	return $new_array;
}

function umg_count_subcats ($catids, $parentids, $catid, $parentid)
{
	$category_list = $parentlist = array ();
	umg_get_subcategories ($category_list, $parent_list, $catid, $catids, $parentids, -1);

	return $category_list;
}

function umg_delete_category ($catid, $delmedia)
{
	global $db, $vbulletin;

	$category = $db->query_first ("SELECT userid FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $catid);
	if ($category['userid'] != $vbulletin->userinfo['userid'])
	{
		if (!$category['userid'] AND $vbulletin->userinfo['deletecat'])
		{
		}
		else print_no_permission ();
	}

	if ($delmedia)
	{
		// delete all medias
		$medias = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_media WHERE catid=" . $catid);
		while ($media = $db->fetch_array ($medias))
		{
			// delete tags first
			$tags = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_tagmedia WHERE mediaid=" . $media['mediaid']);
			while ($tag = $db->fetch_array ($tags))
			{
				$tc = $db->query_first ("SELECT COUNT(tagid) AS tagcount FROM " . TABLE_PREFIX . "umg_tagmedia WHERE tagid=" . $tag['tagid']);
				if ($tc['tagcount'] == 1)
				{
					// delete the tag
					$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_tag WHERE tagid=" . $tag['tagid']);
				}
				$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_tagmedia WHERE tagid=" . $tag['tagid'] . " AND mediaid=" . $tag['mediaid']);
			}

			// delete media ratings
			$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_rating WHERE mediaid=" . $media['mediaid']);

			// delete category counts
			$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_counts WHERE catid=" . $catid);

			// delete media comments
			$db->query_write ("DELETE FROM " . TABLE_PREFIX . "umg_comment WHERE mediaid=" . $media['mediaid']);

			// delete files on server
			if ($media['efilename'])
			{
				if ($media['filetype'] != 'url')
				{
					// we have a real file on the server so unlink it
					@unlink (DIR . '/umg_gallery/images/' . $category['userid'] . '/original/' . $media['mediaid'] . '_' . $media['efilename']);
				}
			}
			@unlink (DIR . '/umg_gallery/images/' . $category['userid'] . '/small/' . $media['mediaid'] . '_' . $media['filename']);
			@unlink (DIR . '/umg_gallery/images/' . $category['userid'] . '/medium/' . $media['mediaid'] . '_' . $media['filename']);
			@unlink (DIR . '/umg_gallery/images/' . $category['userid'] . '/original/' . $media['mediaid'] . '_' . $media['filename']);

			$db->query ("DELETE FROM " . TABLE_PREFIX . "umg_media WHERE mediaid=" . $media['mediaid']);
		}
	}

	$db->query ("DELETE FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $catid);

	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_category");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_comment");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_counts");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_media");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_rating");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_tag");
	$db->query ("OPTIMIZE TABLE " . TABLE_PREFIX . "umg_tagmedia");
	
	umg_create_datastore ('stats');
}

function umg_add_category ($userid = 0)
{
	global $db, $vbulletin, $real_months;

	$p = array ();
	if (count ($vbulletin->GPC['perms']))
	{
		$p = array ();
		foreach ($vbulletin->GPC['perms'] as $key => $val)
		{
			$p[] = $key;
		}
	}

	$moderate = $vbulletin->GPC['moderate'];
	if (!$moderate) $moderate = 0;

	$timestamp = $buddies = $friends = 0;
	if ($vbulletin->GPC['buddie'][0]) $buddies = 1;
	if ($vbulletin->GPC['buddie'][1]) $friends = 1;

	if ($vbulletin->GPC['tday'] AND $vbulletin->GPC['tmonth'] AND $vbulletin->GPC['tyear'])
	{
		$hour = $vbulletin->GPC['thour'];
		$min  = $vbulletin->GPC['tmin'];
		if (!$hour) $hour = 0;
		if (!$min)  $min  = 0;
		$time_string = $vbulletin->GPC['tday'] . ' ' . $real_months[$vbulletin->GPC['tmonth']] . ' ' . $vbulletin->GPC['tyear'];
		if ($hour) $time_string .= ' ' . $hour . ' hours';
		if ($min)  $time_string .= ' ' . $min  . ' minutes';
		$timestamp = strtotime ($time_string);
	}

	umg_insert_category (
		$db->escape_string ($vbulletin->GPC['title']), 
		$db->escape_string ($vbulletin->GPC['description']), 
		0, 
		$vbulletin->GPC['useimages'], 
		$vbulletin->GPC['usemedia'], 
		implode (',', $p), 
		$buddies, 
		$friends, 
		$timestamp, 
		intval ($_POST['catid']), 
		$vbulletin->GPC['sortorder'], 
		$userid, 
		'',
		$vbulletin->GPC['rateit'], 
		$vbulletin->GPC['comments'], 
		$vbulletin->GPC['modcomm'],
		$moderate
	);

	umg_create_datastore ('stats');
}

function umg_upgrade_category ($catid)
{
	global $db, $vbulletin, $real_months, $vbphrase;

	$new_permissions = array ();
	$oldcategory = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $vbulletin->GPC['oldcatid']);
	if (count ($vbulletin->GPC['perms']))
	{
		foreach ($vbulletin->GPC['perms'] AS $key => $val)
		{
			$new_permissions[] = $key;
		}
	}

	$change_subcats = $del_friends = $del_buddies = 0;
	$add_permissions = $sub_permissions = array ();

	// check new permissions
	$new_permission = '';
	if (count ($new_permissions))
	{
		$p = array ();
		$old_permissions = explode (',', $oldcategory['permission']);
		foreach ($old_permissions AS $key => $val)
		{
			if (!in_array ($val, $new_permissions))
			{
				$sub_permissions[] = $val;
			}
		}

		// so let's create the new permissions
		if (count ($sub_permissions)) $change_subcats = 1;
		$new_permission = implode(',', $new_permissions);
	}

	if ($vbulletin->GPC['oldcatid'] == $catid OR $oldcategory['parentid'] == $catid)
	{
		// check friends & buddies
		if (!$vbulletin->GPC['buddie'][1]) $del_friends = $change_subcats = 1;
		if (!$vbulletin->GPC['buddie'][0]) $del_buddies = $change_subcats = 1;
	}
	else
	{
		// check friends & buddies
		$oldcategory = $db->query_first ("SELECT buddies,friends,title FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $catid);
		if (!$oldcategory['friends']) $del_friends = $change_subcats = 1;
		if (!$oldcategory['buddies']) $del_buddies = $change_subcats = 1;
	}

	// if nessesary, set our subcategories to the new permissions
	if ($change_subcats)
	{
		$category_list = $parent_list = array ();
		umg_get_categories ($category_list, $parent_list, $vbulletin->GPC['oldcatid'], -1);
		unset ($category_infos);

		if (count ($category_list))
		{
			foreach ($category_list AS $sub_catid)
			{
				$subcat = $db->query_first ("SELECT buddies,friends,permission FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $sub_catid);
				// do we need to change permissions
				if (count ($sub_permissions))
				{
					if ($subcat['permission'] != '')
					{
						$new_perms = array ();
						$this_perms = explode (',', $subcat['permission']);
						foreach ($this_perms AS $del_groupid)
						{
							if (!in_array ($del_groupid, $sub_permissions))
							{
								$new_perms[] = $del_groupid;
							}
						}
					}
					$sub_permission = implode (',', $new_perms);
				}
				else $sub_permission = $subcat['permission'];

				if ($del_friends AND $subcat['friends']) $friends = 0;
				else $friends = $subcat['friends'];

				if ($del_buddies AND $subcat['buddies']) $buddies = 0;
				else $buddies = $subcat['buddies'];

				// upgrade sub-categories
				$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_category SET 
					`permission` ='" . $db->escape_string ($sub_permission) . "',
					`buddies`    =" . $buddies . ",
					`friends`    =" . $friends . "
					WHERE catid=" . $sub_catid
				);
			}
		}
	}

	$timestamp = 0;
	$buddies = $vbulletin->GPC['buddie'][0];
	$friends = $vbulletin->GPC['buddie'][1];
	if (!$vbulletin->GPC['buddie'][0] OR $del_buddies) $buddies = 0;
	if (!$vbulletin->GPC['buddie'][1] OR $del_friends) $friends = 0;

	// upgrade main-categories

	$moderate = $vbulletin->GPC['moderate'];
	if (!$moderate) $moderate = 0;

	$old_timestamp = $oldcategory['timestamp'];
	$old_realpass  = $oldcategory['real_pass'];
	$old_parentid  = $oldcategory['parentid'];

	$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_category SET 
		`title`      ='" . $db->escape_string ($vbulletin->GPC['title']) . "',
		`description`='" . $db->escape_string ($vbulletin->GPC['description']) . "',
		`parentid`   =" . intval ($_POST['catid']) . ",
		`sortorder`  =" . $vbulletin->GPC['sortorder'] . ",
		`useimages`  =" . $vbulletin->GPC['useimages'] . ",
		`usemedia`   =" . $vbulletin->GPC['usemedia'] . ",
		`rateit`     =" . $vbulletin->GPC['rateit'] . ",
		`comments`   =" . $vbulletin->GPC['comments'] . ",
		`modcomm`    =" . $vbulletin->GPC['modcomm'] . ",
		`moderate`   =" . $moderate . ",
		`permission` ='" . $db->escape_string ($new_permission) . "',
		`buddies`    =" . $buddies . ",
		`friends`    =" . $friends . ",
		`timestamp`  =" . $timestamp . ",
		`password`   ='',
		`real_pass`  =''
		WHERE catid=" . $vbulletin->GPC['oldcatid']
	);

	if (!$oldcategory['userid']) $oldcategory['userid'] = 0;
	$pid = $vbulletin->GPC['oldcatid'];
	if (intval ($_POST['catid']) != $old_parentid)
	{
		// we've change the parent
		$pid = intval ($_POST['catid']);
		if ($pid == -1)
		{
			$pid = $vbulletin->GPC['oldcatid'];
		}
		else
		{
			$old = $db->query_first ("SELECT timestamp,real_pass FROM " . TABLE_PREFIX . "umg_category WHERE catid=" . $pid);
			$timestamp = $old_timestamp = $old['timestamp'];
			$real_pass = $old_realpass  = $old['real_pass'];
			$password  = md5 ($real_pass);
		}
	}

	$category_infos = $category_list = $parent_list = $mother_categories = array ();
	umg_get_categories ($category_list, $parent_list, $pid, -1, $oldcategory['userid']);
	$subcat_ids = implode(',', $category_list);

	if ($subcat_ids)
	{
		$subc = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_category WHERE catid IN (0, " . $subcat_ids . ")");
		while ($sub = $db->fetch_array ($subc))
		{
			$upgrade = '';
		}
	}

	umg_create_datastore ('stats');
}

$umgv = '1.4.5 PL2 Lite';

function umg_password_login ($parentid, $userid)
{
	global $vbulletin, $stylevar, $vbphrase, $show;

	$formvars['url'] = $vbulletin->scriptpath;
	$formvars['username'] = $vbulletin->userinfo['username'];

	eval('$html = "' . fetch_template ("umg_password") . '";');

	standard_error ($html);
}

function umg_get_mother_categories ($category_infos, $catid, &$mother_categories)
{
	$keys = array ();
	foreach ($category_infos as $xx => $yy)
	{
		if ($xx) $keys[] = $xx;
	}

	$x = count ($keys);
	for ($i = 0;$i < $x;$i++)
	{
		$cid = $keys[$i];
		if ($category_infos[$cid]['catid'] == $catid)
		{
			$pid = $category_infos[$cid]['parentid'];
			$mother_categories[] = $category_infos[$cid]['catid'];
			umg_get_mother_categories ($category_infos, $pid, $mother_categories);
		}
	}
}

function umg_get_category_permissions ($parent_list, $category_list, $category_infos, $userid, $parentid)
{
	global $db, $vbulletin;

	if (!$userid) $userid = 0;
	$uinfo = array ('buddylist' => ''); 
	if ($userid) $uinfo = fetch_userinfo ($userid);

	$cats_to_show = $passwords = $timestamps = array ();
	foreach ($parent_list as $key => $val)
	{
		if ($val == $parentid AND $category_list[$key] > 0)
		{
			$access = 1;
			$info = $category_infos[$category_list[$key]];
			if ($userid != $info['userid'] OR !$info['userid'])															// get the correct categories
			{
				$access = 0;
				if ($vbulletin->userinfo['userid'] AND ($info['userid'] == $vbulletin->userinfo['userid'] OR UMGADMIN))
				{
					// category owner or UMG-Admin
					$access = 1;
				}
				else
				{
					// check the permissions of the category
					// check buddies first
					if ($userid > 0 AND $info['buddies'] AND $uinfo['buddylist'] != '')
					{
						$buds = explode (' ', $uinfo['buddylist']);
						if (in_array ($vbulletin->userinfo['userid'], $buds)) $access = 1;
					}
					// check usergroups
					if (!$access AND $info['permission'] != '')
					{
						$perm = explode (',', $info['permission']);
						if (in_array ($vbulletin->userinfo['usergroupid'], $perm)) $access = 1;
					}
					// and at least check friends
					if (!$access AND $userid AND $info['friends'])
					{
						$friend = $db->query_first ("SELECT relationid FROM " . TABLE_PREFIX . "userlist WHERE userid=" . $info['userid'] . " AND relationid=" . $userid);
						if ($friend['friend'] == 'yes') $access = 1;
					}
				}
				// access
			}

			if ($access)
			{
				$this_catid = $category_list[$key];
				$password = $timestamp = '';
				umg_check_upper_categories ($parentid, $this_catid, $parent_list, $category_list, $category_infos, $password, $timestamp);
				$passwords[$info['catid']]  = $password;
				$timestamps[$info['catid']] = $timestamp;
				$cats_to_show[$info['catid']] = $info;
			}

		}
	}

	return array ($cats_to_show, $passwords, $timestamps);
}

function umg_check_upper_categories ($parentid, $this_catid, $parent_list, $category_list, $category_infos, &$password, &$timestamp)
{
	if ($parentid == -1)
	{
		if (!$password AND $category_infos[$this_catid]['password']) $password = $category_infos[$this_catid]['password'];
		if (!$timestamp AND $category_infos[$this_catid]['timestamp']) $timestamp = $category_infos[$this_catid]['timestamp'];
	}
	else
	{
		if (!$password AND $category_infos[$parentid]['password']) $password = $category_infos[$parentid]['password'];
		if (!$timestamp AND $category_infos[$parentid]['timestamp']) $timestamp = $category_infos[$parentid]['timestamp'];
		umg_check_upper_categories ($category_infos[$parentid]['parentid'], $this_catid, $parent_list, $category_list, $category_infos, $password, $timestamp);
	}
}

function umg_create_categoryselect ($category_array, $title = 'catid', $selected, $selcat)
{
	$selectfield = "<select name=\"" . $title . "\" onchange=\"changeUsergoups(this.options[this.selectedIndex].value, " . $selcat . ", 0);\">";
	foreach ($category_array as $catid => $title)
	{
		$sel = '';
		if ($selected == $catid) $sel = ' selected="selected"';
		$selectfield .= '<option value="' . $catid . '"' . $sel . '>' . $title . '</option>';
	}
	$selectfield .= '</select>';

	return $selectfield;
}

function umg_create_categorylist (&$catlist, &$listcat, $parentid = -1, $title = '', $include = 0, $spacer = '', $spacer_append = '-', $userid = 0, $generate_list = 0)
{
	global $db, $vbphrase, $clcount, $global_catlist, $generate_link, $missed_parents, $mc_catids;

	if ($include) $missed_parents = array ();
	if (!$include) $mc_catids = array ();
	$catids = $titles = $parentids = $global_catlist = array ();

	$categories = $db->query_read ("SELECT * 
		FROM " . TABLE_PREFIX . "umg_category 
		WHERE userid=" . $userid . " 
		ORDER BY sortorder ASC, title ASC
	");
	while ($category = $db->fetch_array ($categories))
	{
		if ($include OR $category['catid'] > 0)
		{

			// test
			if ($include AND $category['parentid'] != -1)
			{
				if (!in_array ($category['parentid'], $mc_catids))
				{
					$missed_parents[] = $category['parentid'];
				}
			}

			$catids[]    = $category['catid'];
			$mc_catids[] = $category['catid'];
			$titles[]    = $category['title'];
			$parentids[] = $category['parentid'];
			$global_catlist[$category['catid']] = $category;
		}
	}
	$db->free_result ($categories);

	umg_create_categorysublist ($catlist, $listcat, $parentid, $title, $spacer, $spacer_append, $catids, $titles, $parentids, $generate_list, $missed_parents);
	if (count ($missed_parents)) $missed_parents = array_unique ($missed_parents);
}

function umg_correct_counts ($catid)
{
	global $db, $vbulletin;

	if ($catid)
	{
		$count = array ();
		$dateline = $views = $comments = 0;
		$media = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_media WHERE catid=" . $catid);
		while ($m = $db->fetch_array ($media))
		{
			if ($m['dateline'] > $dateline) $dateline = $m['dateline'];
			$views = $views + $m['counter'];
			$co = $db->query_read ("SELECT comid FROM " . TABLE_PREFIX . "umg_comment WHERE mediaid=" . $m['mediaid']);
			$comments = $comments + $db->num_rows ($co);
		}
		$count['mediacount'] = $db->num_rows ($media);
		$count['views'] = $views;
		$count['comcount'] = $comments;

		if (!$count['views'])      $count['views'] = 0;
		if (!$count['comcount'])   $count['comcount'] = 0;
		if (!$count['mediacount']) $count['mediacount'] = 0;
		$db->query_write ("UPDATE 
			" . TABLE_PREFIX . "umg_counts SET 
			mediacount  =" . $count['mediacount'] . ", 
			media_date  =" . $dateline . ", 
			commentcount=" . $count['comcount'] . ", 
			views       =" . $count['views'] . "
			WHERE catid=" . $catid
		);
	}
}

function umg_addsub_counts ($catid, $mediacount = 0, $commentcount = 0, $viewcount = 0, $what = 'add')
{
	global $db, $vbulletin;

	if ($catid)
	{
		$cat = $db->query_first ("SELECT catid FROM " . TABLE_PREFIX . "umg_counts WHERE catid=" . $catid);
		if (!$cat['catid']) $db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_counts (`catid`) VALUES (" . $catid . ")");

		if ($what == 'add')
		{
			if ($viewcount)    $update_query[] = "views=views+'" . $viewcount . "'";
			if ($mediacount)   $update_query[] = "mediacount=mediacount+'" . $mediacount . "'";
			if ($commentcount) $update_query[] = "commentcount=commentcount+'" . $commentcount . "'";
		}
		else
		{
			if ($viewcount)    $update_query[] = "views=view-'" . $viewcount . "'";
			if ($mediacount)   $update_query[] = "mediacount=mediacount-'" . $mediacount . "'";
			if ($commentcount) $update_query[] = "commentcount=commentcount-'" . $commentcount . "'";
		}

		if (count ($update_query))
		{
			$update = implode (',', $update_query);
			$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_counts SET " . $update . " WHERE catid=" . $catid);
		}
		umg_correct_counts ($catid);
	}
}

function umg_set_counts ($catid, $mediaid = 0, $commentid = 0, $comment_date = 0, $views = 0)
{
	global $db, $vbulletin;

	if ($catid)
	{
		$cat = $db->query_first ("SELECT catid FROM " . TABLE_PREFIX . "umg_counts WHERE catid=" . $catid);
		if (!$cat['catid']) $db->query_write ("INSERT INTO " . TABLE_PREFIX . "umg_counts (`catid`) VALUES (" . $catid . ")");

		// update category counter
		$update_query = array ();
		if ($views)        $update_query[] = "views=" . $views;
		if ($mediaid)
		{
			$update_query[] = "mediaid=" . $mediaid;
			if (!$time) $time = TIMENOW;
			$update_query[] = "media_date=" . $time;
			$update_query[] = "mediacount=mediacount+'1'";
		}
		if ($commentid)    $update_query[] = "commentid=" . $commentid;
		if ($comment_date) $update_query[] = "comment_date=" . $comment_date;

		if (count ($update_query))
		{
			$update = implode (',', $update_query);
			$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_counts SET " . $update . " WHERE catid=" . $catid);
		}
		umg_correct_counts ($catid);
	}
}

function umg_create_datastore ($database = '')
{
	global $db, $vbulletin;

	if ($database != '')
	{
		switch ($database)
		{
			case 'stats':
				$datastore = 'umg_statistics';
				$array = umg_create_statistic ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'ecard':
				$datastore = 'umg_ecards';
				$array = umg_create_ecards ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'extensions':
				$datastore = 'umg_extensions';
				$array = umg_create_extensions ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'fields':
				$datastore = 'umg_custom';
				$array = umg_create_customs ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'counter_private':
				$datastore = 'umg_private';
				$array = umg_statistic_private_counter ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'counter_public':
				$datastore = 'umg_public';
				$array = umg_statistic_public_counter ();
				build_datastore ($datastore, serialize ($array));
				break;
			case 'psettings':
				$datastore = 'umg_psettings';
				$array = umg_statistic_profile_settings ();
				build_datastore ($datastore, serialize ($array));
				break;
		}
	}
}

function umg_statistic_profile_settings ()
{
	global $db, $vbulletin;

	$array = $db->query_first ("SELECT * FROM " . TABLE_PREFIX . "umg_profile_settings");

	return $array;
}

function umg_create_customs ()
{
	global $db, $vbulletin;

	$array = array ();
	$customs = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_custom ORDER BY sortorder ASC");
	while ($custom = $db->fetch_array ($customs))
	{
		$array["$custom[id]"] = $custom;
	}
	$db->free_result ($customs);

	return $array;
}

function umg_create_ecards ()
{
	global $db, $vbulletin;

	$array = array ();
	$ecards = $db->query_read ("SELECT id,userid,dateline,viewed FROM " . TABLE_PREFIX . "umg_ecards ORDER BY id ASC");
	while ($card = $db->fetch_array ($ecards))
	{
		$array["$card[id]"] = array ('userid' => $card['userid'], 'dateline' => $card['dateline'], 'viewed' => $card['viewed']);
	}
	$db->free_result ($ecards);

	return $array;
}

function umg_create_extensions ()
{
	global $db, $vbulletin;

	$array = array ();
	$extensions = $db->query_read ("SELECT * FROM " . TABLE_PREFIX . "umg_extensions ORDER BY extension ASC");
	while ($extension = $db->fetch_array ($extensions))
	{
		$array["$extension[extension]"] = $extension;
	}
	$db->free_result ($extensions);

	return $array;
}

function umg_statistic_public_counter ()
{
	global $db, $vbulletin;

	$public = $db->query_first ("
		SELECT SUM(media.counter) AS counts 
		FROM " . TABLE_PREFIX . "umg_category AS category 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.catid=category.catid) 
		WHERE category.userid=0
	");
	return array ('public' => $public['counts']);
}

function umg_statistic_private_counter ()
{
	global $db, $vbulletin;

	$private = $db->query_first ("
		SELECT SUM(media.counter) AS counts 
		FROM " . TABLE_PREFIX . "umg_category AS category 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.catid=category.catid) 
		WHERE category.userid>=1
	");
	$counts = $private['counts'];
	if (!$counts OR $counts = '') $counts = 0;
	return array ('private' => $counts);
}

function umg_create_statistic ()
{
	global $db, $vbulletin;

	$public_cats  = $db->query_first ("SELECT COUNT(catid) AS globcats FROM " . TABLE_PREFIX . "umg_category WHERE userid=0");
	$public_meds = $db->query_first ("SELECT 
		COUNT(media.mediaid) AS globmeds, SUM(media.filesize) AS globfilesize, SUM(media.counter) AS globcount 
		FROM " . TABLE_PREFIX . "umg_category AS category 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.catid=category.catid) 
		WHERE category.userid=0
	");
	$comments = $db->query ("SELECT 
		comment.comid 
		FROM " . TABLE_PREFIX . "umg_comment AS comment 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.mediaid=comment.mediaid)
		LEFT JOIN " . TABLE_PREFIX . "umg_category AS category ON (category.catid=media.catid) 
		WHERE category.userid=0
	");
	$public_meds['globcoms'] = $db->num_rows ($comments);
	$private_cats = $db->query_first ("SELECT COUNT(catid) AS privcats FROM " . TABLE_PREFIX . "umg_category WHERE userid!=0");
	$private_meds = $db->query_first ("SELECT 
		COUNT(media.mediaid) AS privmeds, SUM(media.filesize) AS privfilesize, SUM(media.counter) AS privcount 
		FROM " . TABLE_PREFIX . "umg_category AS category 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.catid=category.catid) 
		WHERE category.userid!=0
	");
	$comments = $db->query ("SELECT 
		comment.comid 
		FROM " . TABLE_PREFIX . "umg_comment AS comment 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.mediaid=comment.mediaid)
		LEFT JOIN " . TABLE_PREFIX . "umg_category AS category ON (category.catid=media.catid) 
		WHERE category.userid!=0
	");
	$private_meds['privcoms'] = $db->num_rows ($comments);
	$users = array ();
	$private_user = $db->query ("SELECT 
		u.username,c.*,SUM(filesize) AS usersize, COUNT(mediaid) AS medias 
		FROM " . TABLE_PREFIX . "umg_category AS c 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS m ON (m.catid=c.catid) 
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=c.userid) 
		WHERE c.userid!=0 
		GROUP BY c.userid
	");
	$usercount = $db->num_rows ($private_user);
	while ($pu = $db->fetch_array ($private_user))
	{
		if ($pu['usersoze'] == '') $pu['usersoze'] = 0;
		$users["$pu[userid]"] = array ('filesize' => $pu['usersize'], 'medias' => $pu['medias'], 'username' => $pu['username']);
	}
	$db->free_result ($private_user);

	$stats = array (
		'public_categories'  => $public_cats['globcats'],
		'public_media'       => $public_meds['globmeds'],
		'public_filesize'    => $public_meds['globfilesize'],
		'public_views'       => $public_meds['globcount'],
		'public_comments'    => $public_meds['globcoms'],
		'private_categories' => $private_cats['privcats'],
		'private_media'      => $private_meds['privmeds'],
		'private_filesize'   => $private_meds['privfilesize'],
		'private_views'      => $private_meds['privcount'],
		'private_comments'   => $private_meds['privcoms'],
		'private_usercount'  => $usercount,
		'private_users'      => $users
	);

	return $stats;
}

function umg_set_filesize ($size)
{
	$unit = '';
	if ($size == '') $size = 0;
	if ($size >=0 AND $size < 1024) $unit = ' Bytes';
	else if ($size >= 1024 AND $size < 1048576)
	{
		$size = round ($size / 1024, 2);
		$unit = ' KB';
	}
	else if ($size >= 1048576 AND $size < 1073741824)
	{
		$size = round($size / 1048576, 2);
		$unit = ' MB';
	}
	else if ($size >= 1073741824 AND $size < 1099511627776)
	{
		$size = round ($size / 1073741824, 2);
		$unit = ' GB';
	}

	return $size . $unit;
}

function umg_show_stats ()
{
	global $vbulletin;

	$statstext = '';
	$statstext = unserialize ($vbulletin->umg_statistics);

	$statstext['public_filesize'] = umg_set_filesize ($statstext['public_filesize']);
	$statstext['private_filesize'] = umg_set_filesize ($statstext['private_filesize']);

	return $statstext;
}

function umg_create_categorysublist (&$catlist, &$listcat, $parentid, $title, $spacer, $spacer_append, &$catids, &$titles, &$parentids, $generate, &$missed_parents)
{
	global $clcount, $global_catlist, $generate_link, $mc_catids;

	if ($parentid < 0)
	{
		$catlist = array ('-1' => $title);
	}

	$n = count ($catids);
	for ($i = 0; $i < $n; $i++)
	{
		$no = 0;
		if ($parentid == $parentids[$i])
		{
//			$catlist["$catids[$i]"] = $spacer . ' ' . $titles["$i"] . ' ';
			if ($generate == 1)
			{
				$catlist["$catids[$i]"] = $spacer . ' ' . $titles["$i"] . ' ';
				$listcat["$catids[$i]"] = $spacer . ' <a href="umg.php?' . $session['sessionurl'] . umg_create_link ($generate_link, 'catid', $catids["$i"]) . '">' . $titles["$i"] . '</a>';
			}
			else if ($generate == 2)
			{
				if ($global_catlist["$catids[$i]"]['timestamp'] AND $global_catlist["$catids[$i]"]['timestamp'] > TIMENOW AND !UMGADMIN)
				{
					$no = 1;
				}
				else
				{
					$catlist["$catids[$i]"] = $spacer . ' ' . $titles["$i"] . ' ';
					$listcat["$catids[$i]"]['images'] = $global_catlist["$catids[$i]"]['useimages'];
					$listcat["$catids[$i]"]['medias'] = $global_catlist["$catids[$i]"]['usemedia'];
					if (!$global_catlist["$catids[$i]"]['useimages'] AND !$global_catlist["$catids[$i]"]['usemedia'])
					{
						$listcat["$catids[$i]"]['title'] = $spacer . ' ' . $titles["$i"];
					}
					else
					{
						$listcat["$catids[$i]"]['title'] = $spacer . ' <a href="umg.php?' . $session['sessionurl'] . umg_create_link ($generate_link, 'catid', $catids["$i"]) . '">' . $titles["$i"] . '</a>';
					}
				}
			}
			else if ($generate == 3)
			{
				if ($global_catlist["$catids[$i]"]['timestamp'] AND $global_catlist["$catids[$i]"]['timestamp'] > TIMENOW AND !UMGADMIN)
				{
					$no = 1;
				}
				else
				{
					$catlist["$catids[$i]"] = $spacer . ' ' . $titles["$i"] . ' ';
					$listcat["$catids[$i]"]['title'] = $spacer . ' ' . $titles["$i"];
				}
			}

			if (!$no AND $catids[$i] >= 0) umg_create_categorysublist ($catlist, $listcat, $catids[$i], $title, $spacer . $spacer_append, $spacer_append, $catids, $titles, $parentids, $generate, $missed_parents);
		}
	}
}

function umg_get_categories (&$category_list, &$parent_list, $catid = -1, $depth = -1, $userid = 0)
{
	global $db, $category_infos;

	$catids = $parentids = array ();
	$categories = $db->query_read ("SELECT 
		category.*,
		media.filename,media.title AS medtitle,
		counts.media_date,counts.mediaid,counts.mediacount,counts.commentcount,counts.commentid,counts.comment_date,counts.views AS catviews,
		comment.userid AS cuserid,comment.title AS ctitle,counts.comment_username AS cusername,counts.commentmid,
		user.username 
		FROM " . TABLE_PREFIX . "umg_category AS category 
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=category.userid) 
		LEFT JOIN " . TABLE_PREFIX . "umg_counts AS counts ON (counts.catid=category.catid) 
		LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.comid=counts.commentid) 
		LEFT JOIN " . TABLE_PREFIX . "umg_media AS media ON (media.mediaid=counts.mediaid) 
		WHERE category.userid=" . $userid . " 
		ORDER BY category.sortorder, category.title
	");
	while ($category = $db->fetch_array ($categories))
	{
		$catids[]                           = $category['catid'];
		$parentids[]                        = $category['parentid'];
		$category_infos[$category['catid']] = $category;
	}

	if (!in_array (0, $catids))
	{
		$catids[]          = 0;
		$parentids[]       = -1;
		$category_infos[0] = array ();
	}

	umg_get_subcategories ($category_list, $parent_list, $catid, $catids, $parentids, $depth);
}

function umg_get_subcategories (&$category_list, &$parent_list, $catid, &$catids, &$parentids, $depth)
{
	global $category_infos;

	$x = count ($catids);
	for ($i = 0; $i < $x; $i++)
	{
		if ($catid == $parentids[$i])
		{
			$category_list[] = $catids[$i];
			$parent_list[]   = $catid;
			if (($catids[$i] >= 0) AND ($depth != 0))
			{
				umg_get_subcategories ($category_list, $parent_list, $catids[$i], $catids, $parentids, $depth - 1);
			}
		}
	}
}

function umg_create_link ($content, $search, $replace)
{
	$content = str_replace ('{' . $search . '}', $replace, $content);

	return $content;
}

function umg_create_date_select ($count, $start = 1, $step = 1, $selected = 0, $tm = 0, $no = 0)
{
	global $vbphrase, $month_array;

	$selector = '';
	if ($no)
	{
		$selector = '<option value="0">--</option>';
	}
	for ($x = 1; $x < $count; $x++)
	{
		$sel = '';
		$val = $start;
		if ($selected == $start) $sel = ' selected="selected"';

		if (!$tm)
		{
			$selector .= '<option value="' . $start . '"' . $sel . '>' . $val . '</option>';
		}
		else if ($tm == 1)
		{
			$val = $month_array[$val];
			$selector .= '<option value="' . $start . '"' . $sel . '>' . $val . '</option>';
		}
		else if ($tm == 2)
		{
			if ($val < 10) $val = '0' . $val;
			$selector .= '<option value="' . $start . '"' . $sel . '>' . $val . '</option>';
		}
		$start += $step;
	}

	return $selector;
}

function umg_usergroup_select ()
{
	global $db, $ugroups;

	$count = 0;
	$ugroups = array ();
	$usergroup_select = '<tr>';
	$usergroups = $db->query ("SELECT * FROM " . TABLE_PREFIX . "usergroup");
	while ($usergroup = $db->fetch_array ($usergroups))
	{
		$ugroups[] = $usergroup['usergroupid'];
		$usergroup_select .= '<td><input id="perm' . $usergroup['usergroupid'] . '" type="checkbox" name="perms[' . $usergroup['usergroupid'] . ']" value="1" /> ' . $usergroup['title'] . '</td>';
		$count++;
		if ($count == 2)
		{
			$count = 0;
			$usergroup_select .= '<tr></tr>';
		}
	}
	$usergroup_select .= '</tr>';

	return $usergroup_select;
}

function umg_insert_category ($title, $description = '', $pripu = 0, $useimages, $usemedia, $perms, $buddies, $friends, $timestamp, $parentid, $order = 0, $userid = 0, $password, $rateit, $comments, $modcomm, $moderate)
{
	global $db, $vbphrase, $category_infos;

	if ($title == '') $title = $vbphrase['umg_error_no_title'];

	$db->query_write ("INSERT INTO 
		" . TABLE_PREFIX . "umg_category 
		(`title`, `description`, `pripu`, `useimages`, `usemedia`, `permission`, `buddies`, `friends`, `dateline`, `timestamp`, `parentid`, `sortorder`, `userid`, `password`, `real_pass`, `rateit`, `comments`, `modcomm`, `moderate`) 
		VALUES 
		('" . $title . "', '" . $description . "', " . $pripu . ", " . $useimages . ", " . $usemedia . ", '" . $perms . "', " . $buddies . ", " . $friends . ", " . TIMENOW . ", 0, " . $parentid . ", " . $order . ", " . $userid . ", '', '', " . $rateit . ", " . $comments . ", " . $modcomm . ", " . $moderate . ")
	");
	$new_catid = $db->insert_id ();
}
?>